#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Spiral #6Mod01.fsh   by     lsdlive 
//https://www.shadertoy.com/view/dddGWB
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*
@lsdlive
CC-BY-NC-SA

Spiral #6

Log-polar coordinates with a diagonal checker.
Inspired by the figure on the right:
https://en.wikipedia.org/wiki/Log-polar_coordinates#Discrete_geometry

*/

#define bpm 120.
#define speed .5
#define tiling 4.
#define line_sz .03

#define AA 4.

#define pi 3.14159265359
#define time (speed*(bpm/60.)*iTime)
//#define time (mod(speed*(bpm/60.)*iTime, 2.)) // 2s loop with default settings

// https://lospec.com/palette-list/1bit-monitor-glow
vec3 col1 = vec3(.133, .137, .137);
vec3 col2 = vec3(.941, .965, .941);

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord - .5 * iResolution.xy) / iResolution.y;

    float aa_falloff = 12. * pow(1.3 - length(uv), 2.);
    
    float angle = atan(uv.y, uv.x) / (pi * .5);
    float len = log(length(uv));
    
    float t1 = fract(time * .25);
    uv = vec2(angle, len - t1);

    //vec2 flip = step(.5, fract(uv * tiling * .5)) * 2. - 1.;
    // FabriceNeyret2 suggestion:
    uv *= tiling;
    vec2 flip = sign(mod(uv, 2.) - 1.);
    uv = fract(uv);

    float t2 = fract(time * .5);
    /*if (uv.x > uv.y) {
        uv += flip.x * flip.y * t2;
    } else {
        uv -= flip.x * flip.y * t2;
    }*/
    // FabriceNeyret2 suggestion:
    uv += flip.x * flip.y * sign(uv.x - uv.y) * t2;

    uv = fract(uv + .5) - .5;
    uv = abs(uv);
    float mask = smoothstep(0., aa_falloff * AA / iResolution.x, uv.y - uv.x - line_sz);
    vec3 col = mix(col1, col2, mask);

    fragColor = vec4(col, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

